'use client';

import React from 'react';
import AnimatedElement from './AnimatedElement';

interface WithAnimationProps {
  animation?: 'fadeIn' | 'slideInUp' | 'slideInDown' | 'slideInLeft' | 'slideInRight' | 'zoomIn' | 'bounceIn' | 'flipInX' | 'flipInY' | 'rotateIn';
  delay?: number;
  duration?: number;
  className?: string;
}

export function withAnimation<P extends object>(
  WrappedComponent: React.ComponentType<P>,
  defaultAnimation: WithAnimationProps = {}
) {
  return function WithAnimationComponent(props: P & WithAnimationProps) {
    const {
      animation = defaultAnimation.animation || 'fadeIn',
      delay = defaultAnimation.delay || 0,
      duration = defaultAnimation.duration || 800,
      className = defaultAnimation.className || '',
      ...restProps
    } = props;

    return (
      <AnimatedElement
        animation={animation}
        delay={delay}
        duration={duration}
        className={className}
      >
        <WrappedComponent {...(restProps as P)} />
      </AnimatedElement>
    );
  };
}

// Утилита для создания анимированных версий компонентов
export function createAnimatedComponent<P extends object>(
  Component: React.ComponentType<P>,
  animationProps: WithAnimationProps = {}
) {
  return withAnimation(Component, animationProps);
} 