'use client';

import Image from 'next/image';
import { useTranslations } from 'next-intl';
import AnimatedText from './AnimatedText';
import AnimatedElement from './AnimatedElement';

// Компонент для отображения медиа (видео или изображение)
function MediaCard({ src, alt, isVideo = false }: { src: string; alt: string; isVideo?: boolean }) {
  if (isVideo) {
    return (
      <div className="absolute inset-0 w-full h-full">
        <video
          className="w-full h-full object-cover absolute inset-0"
          autoPlay
          muted
          loop
          playsInline
        >
          <source src={src} type="video/mp4" />
          Your browser does not support the video tag.
        </video>
      </div>
    );
  }
  
  return (
    <Image
      src={src}
      alt={alt}
      fill
      className="object-cover absolute inset-0"
    />
  );
}

export default function VillageInfrastructure() {
  const t = useTranslations('VillageInfrastructure');

  const infrastructureCards = [
    {
      title: t('card1.title'),
      description: t('card1.description'),
      media: "/images/logo/doc_2025-07-08_00-42-09.mp4",
      isVideo: true
    },
    {
      title: t('card2.title'),
      description: t('card2.description'),
      media: "/images/logo/d95caca82045d9a2e65baf1126cee47a0e95ee05.png",
      isVideo: false
    },
    {
      title: t('card3.title'),
      description: t('card3.description'),
      media: "/images/logo/78122acf755568c0202b6dfccfd5940b0ed90fd3.jpg",
      isVideo: false
    },
    {
      title: t('card4.title'),
      description: t('card4.description'),
      media: "/images/logo/377917313268363269.mp4",
      isVideo: true
    },
    {
      title: t('card5.title'),
      description: t('card5.description'),
      media: "/images/logo/3.mp4",
      isVideo: true
    },
    {
      title: t('card6.title'),
      description: t('card6.description'),
      media: "/images/logo/52c1b8d987dd726108142c4c10bfe8f5b44c2cff.jpg",
      isVideo: false
    }
  ];

  return (
    <section className="w-full bg-[#f5f1f0] py-[60px] px-3 lg:px-8 lg:h-[1970px] flex flex-col items-center gap-[60px]">
      {/* Title */}
      <AnimatedText
        as="h2"
        animation="slideInUp"
        delay={200}
        className="text-[#1c1c1c] font-roboto text-[40px] font-light leading-[115%] tracking-[-1.2px] text-center"
      >
        {t('title')}
      </AnimatedText>

      {/* Cards Grid */}
      <div className="max-w-[1376px] w-full flex flex-col gap-[50px]">
        
        {/* Mobile: Стакаются вертикально, Desktop: Row 1 */}
        <div className="flex flex-col lg:flex-row gap-10">
          <div className="flex-1 flex flex-col">
            <AnimatedElement animation="slideInLeft" delay={300} className="h-[378px] relative overflow-hidden w-full">
              <MediaCard
                src={infrastructureCards[0].media}
                alt={infrastructureCards[0].title}
                isVideo={infrastructureCards[0].isVideo}
              />
            </AnimatedElement>
            <div className="lg:h-[179px] pt-6 flex flex-col gap-4">
              <AnimatedText
                as="h3"
                animation="slideInLeft"
                delay={400}
                className="text-[#1c1c1c] font-roboto text-2xl font-light leading-[130%]"
              >
                {infrastructureCards[0].title}
              </AnimatedText>
              <AnimatedText
                as="p"
                animation="slideInLeft"
                delay={600}
                className="text-[#1c1c1c] font-roboto text-lg font-light leading-[150%] whitespace-pre-line"
              >
                {infrastructureCards[0].description}
              </AnimatedText>
            </div>
          </div>
          
          <div className="flex-1 flex flex-col">
            <AnimatedElement animation="slideInRight" delay={300} className="h-[378px] relative overflow-hidden w-full">
              <MediaCard
                src={infrastructureCards[1].media}
                alt={infrastructureCards[1].title}
                isVideo={infrastructureCards[1].isVideo}
              />
            </AnimatedElement>
            <div className="lg:h-[179px] pt-6 flex flex-col gap-4">
              <AnimatedText
                as="h3"
                animation="slideInRight"
                delay={400}
                className="text-[#1c1c1c] font-roboto text-2xl font-light leading-[130%]"
              >
                {infrastructureCards[1].title}
              </AnimatedText>
              <AnimatedText
                as="p"
                animation="slideInRight"
                delay={600}
                className="text-[#1c1c1c] font-roboto text-lg font-light leading-[150%] whitespace-pre-line"
              >
                {infrastructureCards[1].description}
              </AnimatedText>
            </div>
          </div>
        </div>

        {/* Mobile: Стакаются вертикально, Desktop: Row 2 */}
        <div className="flex flex-col lg:flex-row gap-10 lg:items-center">
          <div className="flex-1 flex flex-col">
            <AnimatedElement animation="slideInLeft" delay={700} className="h-[378px] relative overflow-hidden w-full">
              <MediaCard
                src={infrastructureCards[2].media}
                alt={infrastructureCards[2].title}
                isVideo={infrastructureCards[2].isVideo}
              />
            </AnimatedElement>
            <div className="lg:h-[179px] pt-6 flex flex-col gap-4">
              <AnimatedText
                as="h3"
                animation="slideInLeft"
                delay={800}
                className="text-[#1c1c1c] font-roboto text-2xl font-light leading-[130%]"
              >
                {infrastructureCards[2].title}
              </AnimatedText>
              <AnimatedText
                as="p"
                animation="slideInLeft"
                delay={1000}
                className="text-[#1c1c1c] font-roboto text-lg font-light leading-[150%] whitespace-pre-line"
              >
                {infrastructureCards[2].description}
              </AnimatedText>
            </div>
          </div>
          
          <div className="flex-1 flex flex-col">
            <AnimatedElement animation="slideInRight" delay={700} className="h-[378px] relative overflow-hidden w-full">
              <MediaCard
                src={infrastructureCards[3].media}
                alt={infrastructureCards[3].title}
                isVideo={infrastructureCards[3].isVideo}
              />
            </AnimatedElement>
            <div className="lg:h-[179px] pt-6 flex flex-col gap-4">
              <AnimatedText
                as="h3"
                animation="slideInRight"
                delay={800}
                className="text-[#1c1c1c] font-roboto text-2xl font-light leading-[130%]"
              >
                {infrastructureCards[3].title}
              </AnimatedText>
              <AnimatedText
                as="p"
                animation="slideInRight"
                delay={1000}
                className="text-[#1c1c1c] font-roboto text-lg font-light leading-[150%] whitespace-pre-line"
              >
                {infrastructureCards[3].description}
              </AnimatedText>
            </div>
          </div>
        </div>

        {/* Mobile: Стакаются вертикально, Desktop: Row 3 */}
        <div className="flex flex-col lg:flex-row gap-10 lg:items-center">
          <div className="flex-1 flex flex-col">
            <AnimatedElement animation="slideInLeft" delay={1100} className="h-[378px] relative overflow-hidden w-full">
              <MediaCard
                src={infrastructureCards[4].media}
                alt={infrastructureCards[4].title}
                isVideo={infrastructureCards[4].isVideo}
              />
            </AnimatedElement>
            <div className="lg:h-[179px] pt-6 flex flex-col gap-4">
              <AnimatedText
                as="h3"
                animation="slideInLeft"
                delay={1200}
                className="text-[#1c1c1c] font-roboto text-2xl font-light leading-[130%]"
              >
                {infrastructureCards[4].title}
              </AnimatedText>
              <AnimatedText
                as="p"
                animation="slideInLeft"
                delay={1400}
                className="text-[#1c1c1c] font-roboto text-lg font-light leading-[150%] whitespace-pre-line"
              >
                {infrastructureCards[4].description}
              </AnimatedText>
            </div>
          </div>
          
          <div className="flex-1 flex flex-col">
            <AnimatedElement animation="slideInRight" delay={1100} className="h-[378px] relative overflow-hidden w-full">
              <MediaCard
                src={infrastructureCards[5].media}
                alt={infrastructureCards[5].title}
                isVideo={infrastructureCards[5].isVideo}
              />
            </AnimatedElement>
            <div className="lg:h-[179px] pt-6 flex flex-col gap-4">
              <AnimatedText
                as="h3"
                animation="slideInRight"
                delay={1200}
                className="text-[#1c1c1c] font-roboto text-2xl font-light leading-[130%]"
              >
                {infrastructureCards[5].title}
              </AnimatedText>
              <AnimatedText
                as="p"
                animation="slideInRight"
                delay={1400}
                className="text-[#1c1c1c] font-roboto text-lg font-light leading-[150%] whitespace-pre-line"
              >
                {infrastructureCards[5].description}
              </AnimatedText>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
} 