'use client';

import Image from 'next/image';
import { useTranslations } from 'next-intl';
import { useEffect, useState, useRef } from 'react';

export default function PartnersSection() {
  const t = useTranslations('PartnersSection');
  const [scrollPosition, setScrollPosition] = useState(0);
  const containerRef = useRef<HTMLDivElement>(null);

  const partners = [
    {
      id: 6,
      name: "Ubeqmen Miracles",
      image: "/images/investors/Partners/973ff326452242271cdebd76ee33bb692d718be2.png",
      width: 283,
      height: 161,
      link: ""
    },
    {
      id: 1,
      name: "LIC Logo",
      image: "/images/investors/Partners/2a3194a0680b444371bf7796c3c5e9028b17c396.png",
      width: 284,
      height: 162,
      link: ""
    },
    {
      id: 5,
      name: "Cintamani",
      image: "/images/investors/Partners/8bc05c5755ec79c77012bcf48a35317b72a87f0c.png",
      width: 180,
      height: 142,
      link: ""
    },
    {
      id: 2,
      name: "Bluseed Holdings",
      image: "/images/investors/Partners/3088c53371a68f1bdaf9d51013a3e51b587d5dd0.png",
      width: 119,
      height: 142,
      link: ""
    },
    {
      id: 4,
      name: "Cintamani",
      image: "/images/logo/cintamani.svg",
      width: 119,
      height: 142,
      link: ""
    },
    {
      id: 3,
      name: "Castle Singapore",
      image: "/images/investors/Partners/622aadb45f31384237007bba185ca1fc6e6a9ef1.png",
      width: 226,
      height: 108,
      link: ""
    }
  ];

  // Создаем дублированный массив для бесконечной прокрутки
  const duplicatedPartners = [...partners, ...partners, ...partners, ...partners];

  useEffect(() => {
    let animationId: number;
    let startTime: number;

    const animate = (currentTime: number) => {
      if (!startTime) startTime = currentTime;
      const elapsed = currentTime - startTime;
      
      // Скорость прокрутки (пикселей в секунду)
      const speed = 50;
      const newPosition = (elapsed * speed / 1000) % (partners.length * 200);
      
      setScrollPosition(newPosition);
      animationId = requestAnimationFrame(animate);
    };

    animationId = requestAnimationFrame(animate);

    return () => {
      if (animationId) {
        cancelAnimationFrame(animationId);
      }
    };
  }, [partners.length]);

  return (
    <section className="flex flex-col items-center justify-center self-stretch bg-white py-[60px] px-3 md:px-8">
      <div className="flex w-full max-w-[1440px] flex-col items-start justify-end gap-10">
        <h2 className="self-stretch text-center font-roboto text-[40px] font-light leading-[115%] tracking-[-1.2px] text-[#1C1C1C]">
          {t('title')}
        </h2>
        
        {/* Карусель партнеров */}
        <div className="relative w-full overflow-hidden" ref={containerRef}>
          {/* Левый fade */}
          <div className="pointer-events-none absolute left-0 top-0 h-full w-16 md:w-32 z-10" style={{background: 'linear-gradient(90deg, white 70%, transparent)'}} />
          {/* Правый fade */}
          <div className="pointer-events-none absolute right-0 top-0 h-full w-16 md:w-32 z-10" style={{background: 'linear-gradient(270deg, white 70%, transparent)'}} />
          <div 
            className="flex items-center gap-8"
            style={{
              transform: `translateX(-${scrollPosition}px)`,
              width: `${duplicatedPartners.length * 228}px`
            }}
          >
            {duplicatedPartners.map((partner, index) => {
              const content = (
                <div 
                  key={`${partner.id}-${index}`}
                  className="relative flex items-center justify-center cursor-pointer flex-shrink-0"
                  style={{
                    width: '220px',
                    height: '120px',
                    outline: '1px solid transparent',
                  }}
                >
                  <Image
                    src={partner.image}
                    alt={partner.name}
                    fill
                    className="object-contain border-none"
                  />
                </div>
              );
              
              return partner.link ? (
                <a
                  key={`${partner.id}-${index}`}
                  href={partner.link}
                  target="_blank"
                  rel="noopener noreferrer"
                  style={{ display: 'block' }}
                >
                  {content}
                </a>
              ) : content;
            })}
          </div>
        </div>
      </div>
    </section>
  );
} 