'use client';

import { useTranslations } from 'next-intl';

interface MediaCardProps {
  title: string;
  description: string;
  date: string;
  source: string;
  image: string;
  link: string;
}

export default function MediaCard({ title, description, date, source, image, link }: MediaCardProps) {
  const tCommon = useTranslations('Common');
  
  const handleReadMore = () => {
    window.open(link, '_blank', 'noopener,noreferrer');
  };

  return (
    <div className="flex flex-col flex-1 bg-white">
      {/* Article Image */}
      <div 
        className="h-[282px] bg-gray-300 bg-cover bg-center"
        style={{
          backgroundImage: `url(${image})`,
          backgroundColor: 'lightgray'
        }}
      />
      
      {/* Article Content */}
      <div className="flex flex-col justify-between h-[309px] p-6 border border-[#A79D94] bg-white">
        <div className="flex flex-col gap-2">
          {/* Title */}
          <h3 
            className="text-[#1C1C1C] text-2xl font-light leading-[130%] overflow-hidden"
            style={{
              display: '-webkit-box',
              WebkitBoxOrient: 'vertical',
              WebkitLineClamp: 2,
              textOverflow: 'ellipsis'
            }}
          >
            {title}
          </h3>
          
          {/* Description */}
          <p 
            className="text-[#1C1C1C] text-lg font-light leading-[150%] overflow-hidden"
            style={{
              display: '-webkit-box',
              WebkitBoxOrient: 'vertical',
              WebkitLineClamp: 3,
              textOverflow: 'ellipsis'
            }}
          >
            {description}
          </p>
        </div>
        
        <div className="flex flex-col gap-4">
          {/* Date and Source */}
          <div className="flex justify-between items-start">
            <span 
              className="text-[#666] text-lg font-light leading-[150%] overflow-hidden"
              style={{
                display: '-webkit-box',
                WebkitBoxOrient: 'vertical',
                WebkitLineClamp: 3,
                textOverflow: 'ellipsis'
              }}
            >
              {date}
            </span>
            <span 
              className="text-[#666] text-lg font-light leading-[150%] overflow-hidden"
              style={{
                display: '-webkit-box',
                WebkitBoxOrient: 'vertical',
                WebkitLineClamp: 3,
                textOverflow: 'ellipsis'
              }}
            >
              {source}
            </span>
          </div>
          
          {/* Read More Button */}
          <button 
            onClick={handleReadMore}
            className="flex h-[51px] px-6 py-3 justify-center items-center gap-2 border border-[#A79D94] bg-white rounded-sm hover:bg-gray-50 transition-colors"
          >
            <span className="text-[#A79D94] text-lg font-semibold">
              {tCommon('read_more')}
            </span>
          </button>
        </div>
      </div>
    </div>
  );
} 