'use client';

import Link from 'next/link';
import { useTranslations, useLocale } from 'next-intl';

export default function InvestmentReasons() {
  const t = useTranslations('InvestmentReasons');
  const tCommon = useTranslations('Common');
  const locale = useLocale();

  const reasons = [
    {
      title: t('card1.title'),
      description: t('card1.description'),
    },
    {
      title: t('card2.title'),
      description: t('card2.description'),
    },
    {
      title: t('card3.title'),
      description: t('card3.description'),
    }
  ];

  return (
    <section className="w-full min-h-[400px] lg:h-[601px] relative overflow-hidden">
      {/* Background Video - показывается на всех устройствах */}
      <video 
        autoPlay
        loop
        muted
        playsInline
        preload="auto"
        className="absolute top-0 left-0 w-full h-full object-cover"
        style={{ zIndex: 1 }}
      >
        <source src="/images/Reasons/Standard_Mode_let_the_clouds_move_and_the_wate (2).mp4" type="video/mp4" />
        <source src="/images/Reasons/10.mp4" type="video/mp4" />
      </video>
      
      {/* Overlay - полупрозрачный белый согласно JSON дизайну */}
      <div 
        className="absolute top-0 left-0 w-full h-full" 
        style={{ 
          zIndex: 2,
          background: 'linear-gradient(0deg, rgba(255, 255, 255, 0.55) 0%, rgba(255, 255, 255, 0.55) 100%)'
        }}
      ></div>
      
      {/* Content */}
      <div className="relative w-full h-full py-[90px] px-3 lg:px-8 flex flex-col items-center gap-[46px]" style={{ zIndex: 10 }}>
        {/* Title */}
        <h2 className="text-[#1c1c1c] font-roboto text-[40px] font-light leading-[115%] tracking-[-1.2px] text-center">
          {t('section_title')}
        </h2>

        {/* Reasons Grid */}
        <div className="max-w-[1376px] w-full flex flex-col lg:flex-row gap-[60px]">
          {reasons.map((reason, index) => (
            <div key={index} className="flex-1 flex flex-col items-center lg:items-start gap-3">
              <div className="flex items-start gap-4 self-stretch">
                <h3 className="flex-1 text-[#1c1c1c] font-roboto text-2xl font-light leading-[130%]">
                  {reason.title}
                </h3>
              </div>
              <p className="text-[#1c1c1c] font-roboto text-lg font-light leading-[150%] self-stretch">
                {reason.description}
              </p>
            </div>
          ))}
        </div>

        {/* Read More Button */}
        <Link href={`/${locale}/reasons-to-invest`} className="w-full lg:w-[160px] h-[51px] bg-[#a79d94] rounded-sm flex items-center justify-center px-6 py-3 gap-2 hover:bg-[#968B82] transition-colors whitespace-nowrap">
          <span className="text-[#f5f1f0] font-roboto text-lg font-normal leading-[150%] whitespace-nowrap">
            {tCommon('read_more')}
          </span>
        </Link>
      </div>
    </section>
  );
} 