'use client';

import Link from 'next/link';
import { useTranslations, useLocale } from 'next-intl';

export default function IntroSection() {
  const t = useTranslations('IntroSection');
  const tCommon = useTranslations('Common');
  const locale = useLocale();

  const getLocalizedPath = (path: string) => {
    if (path === '/') {
        return `/${locale}`;
    }
    return `/${locale}${path}`;
  }

  return (
    <section className="w-full h-[480px] px-8 py-[150px] bg-white flex justify-center items-center gap-10">
      <div className="flex-1 max-w-[1376px] flex flex-col items-start gap-10">
        <div className="w-full flex flex-col items-start gap-3">
          <h1 className="w-full text-[#1C1C1C] text-[40px] font-roboto font-light leading-[46px] tracking-[-1.2px]">
            {t('title')}
          </h1>
          <p className="w-full text-[#1C1C1C] text-2xl font-roboto font-light leading-[31.2px]">
            {t('subtitle')}
          </p>
        </div>
        <Link href={getLocalizedPath('/lake-token')} className="px-6 py-3 bg-[#A79D94] rounded-[2px] flex justify-center items-center gap-2 hover:bg-[#9a8f86] transition-colors">
          <span className="text-white text-lg font-roboto font-normal leading-[27px]">
            {tCommon('lake_token')}
          </span>
        </Link>
      </div>
    </section>
  );
} 