'use client';
import Image from 'next/image';
import { useEffect, useState } from 'react';

export default function FloatingButtons() {
  const [isClient, setIsClient] = useState(false);
  const [isMobile, setIsMobile] = useState(false);
  const [pathname, setPathname] = useState('');

  useEffect(() => {
    setIsClient(true);
    setIsMobile(window.innerWidth < 640);
    setPathname(window.location.pathname);
    const handleResize = () => setIsMobile(window.innerWidth < 640);
    window.addEventListener('resize', handleResize);
    return () => window.removeEventListener('resize', handleResize);
  }, []);

  if (!isClient) return null;

  // Определяем ссылку для WhatsApp
  const phone = '+996221111441';
  const waLink = isMobile
    ? `https://wa.me/${phone}`
    : `https://web.whatsapp.com/send?phone=${phone}`;

  // Только для страницы lake-token
  if (pathname.includes('lake-token')) {
    return (
      <>
        {/* Десктоп: только WhatsApp */}
        <div className="lake-token-float-desktop" style={{ position: 'fixed', right: 24, bottom: 24, zIndex: 9999, display: 'flex', flexDirection: 'column', gap: 16 }}>
          <a
            href={waLink}
            target="_blank"
            rel="noopener noreferrer"
            className="floating-glow-btn"
            aria-label="WhatsApp"
          >
            <Image src="/images/logo/WhatsApp.svg.webp" alt="WhatsApp" width={36} height={36} />
          </a>
        </div>
        {/* Мобильная версия: WhatsApp + Lake Token (логотип logotype1.svg, ссылка на /) */}
        <div className="lake-token-float-mobile" style={{ position: 'fixed', right: 24, bottom: 24, zIndex: 9999, display: 'flex', flexDirection: 'column', gap: 16 }}>
          <a
            href={waLink}
            target="_blank"
            rel="noopener noreferrer"
            className="floating-glow-btn"
            aria-label="WhatsApp"
          >
            <Image src="/images/logo/WhatsApp.svg.webp" alt="WhatsApp" width={36} height={36} />
          </a>
          <a
            href="/"
            className="floating-glow-btn"
            aria-label="Lake Token Home"
          >
            <Image src="/images/logo/logotype1.svg" alt="Lake Token" width={36} height={36} />
          </a>
        </div>
      </>
    );
  }

  // Для остальных страниц — стандартные две кнопки
  return (
    <div style={{ position: 'fixed', right: 24, bottom: 24, zIndex: 9999, display: 'flex', flexDirection: 'column', gap: 16 }}>
      <a
        href={waLink}
        target="_blank"
        rel="noopener noreferrer"
        className="floating-glow-btn"
        aria-label="WhatsApp"
      >
        <Image src="/images/logo/WhatsApp.svg.webp" alt="WhatsApp" width={36} height={36} />
      </a>
      <a
        href="/lake-token"
        className="floating-glow-btn"
        aria-label="Lake Token"
      >
        <Image src="/images/logo/icon.svg" alt="Lake Token" width={36} height={36} />
      </a>
    </div>
  );
} 