'use client';

import { ReactNode } from 'react';
import AnimatedElement from './AnimatedElement';

interface AnimatedTextProps {
  children: ReactNode;
  animation?: 'fadeIn' | 'slideInUp' | 'slideInDown' | 'slideInLeft' | 'slideInRight' | 'zoomIn' | 'bounceIn' | 'flipInX' | 'flipInY' | 'rotateIn';
  delay?: number;
  duration?: number;
  className?: string;
  as?: 'h1' | 'h2' | 'h3' | 'h4' | 'h5' | 'h6' | 'p' | 'span' | 'div';
  stagger?: boolean;
  staggerIndex?: number;
}

export default function AnimatedText({
  children,
  animation = 'fadeIn',
  delay = 0,
  duration = 800,
  className = '',
  as: Component = 'div',
  stagger = false,
  staggerIndex = 0
}: AnimatedTextProps) {
  const staggerDelay = stagger ? staggerIndex * 100 : 0;
  const totalDelay = delay + staggerDelay;

  return (
    <AnimatedElement
      animation={animation}
      delay={totalDelay}
      duration={duration}
      className={className}
    >
      <Component>
        {children}
      </Component>
    </AnimatedElement>
  );
} 