'use client';

import React, { ReactNode } from 'react';
import AnimatedElement from './AnimatedElement';

interface AnimatedListProps {
  children: ReactNode;
  animation?: 'fadeIn' | 'slideInUp' | 'slideInDown' | 'slideInLeft' | 'slideInRight' | 'zoomIn' | 'bounceIn' | 'flipInX' | 'flipInY' | 'rotateIn';
  baseDelay?: number;
  staggerDelay?: number;
  duration?: number;
  className?: string;
  as?: 'ul' | 'ol' | 'div';
}

export default function AnimatedList({
  children,
  animation = 'slideInUp',
  baseDelay = 0,
  staggerDelay = 100,
  duration = 800,
  className = '',
  as: Component = 'div'
}: AnimatedListProps) {
  const childrenArray = React.Children.toArray(children);

  return (
    <Component className={className}>
      {childrenArray.map((child, index) => (
        <AnimatedElement
          key={index}
          animation={animation}
          delay={baseDelay + (index * staggerDelay)}
          duration={duration}
        >
          {child}
        </AnimatedElement>
      ))}
    </Component>
  );
} 