'use client';

import React from 'react';
import AnimatedImage from './AnimatedImage';

interface AnimatedImageWrapperProps {
  src: string;
  alt: string;
  width?: number;
  height?: number;
  className?: string;
  style?: React.CSSProperties;
  isPanorama?: boolean;
  children?: React.ReactNode;
}

export default function AnimatedImageWrapper({
  src,
  alt,
  width,
  height,
  className = '',
  style,
  isPanorama = false,
  children
}: AnimatedImageWrapperProps) {
  // Определяем, является ли изображение панорамным на основе размеров или класса
  const isPanoramic = isPanorama || 
    className.includes('panorama') || 
    className.includes('hero') ||
    (style && style.height && style.width && 
     (style.height as number) / (style.width as number) < 0.5);

  if (isPanoramic) {
    return (
      <div className={className} style={style}>
        <img
          src={src}
          alt={alt}
          width={width}
          height={height}
          className="w-full h-full object-cover"
        />
        {children}
      </div>
    );
  }

  return (
    <AnimatedImage
      src={src}
      alt={alt}
      width={width}
      height={height}
      className={className}
      animation="slideInUp"
      delay={200}
      hoverEffect="zoom"
      isPanorama={false}
    >
      {children}
    </AnimatedImage>
  );
} 