import type { Metadata } from "next";
import { Roboto, Inter } from "next/font/google";
import "./globals.css";
import FloatingButtons from '../components/FloatingButtons';

const roboto = Roboto({
  variable: "--font-roboto",
  subsets: ["latin"],
  weight: ["300", "400", "500", "700"],
});

const inter = Inter({
  variable: "--font-inter",
  subsets: ["latin"],
  weight: ["400", "500", "600"],
});

export const metadata: Metadata = {
  title: "LAKE - Luxury Living meets Web3 Investing",
  description: "Real estate. Real yield. Real impact. Tailored for High-Net-Worth individuals. LAKE redefines exclusive living on the shores of Lake Issyk-Kul.",
};

export default function RootLayout({
  children,
}: {
  children: React.ReactNode;
}) {
  return (
    <html lang="en">
      <body className={`${roboto.variable} ${inter.variable} antialiased`}>
        {children}
        {/* Плавающие кнопки */}
        <FloatingButtons />
      </body>
    </html>
  );
}
