import { NextResponse } from 'next/server';
import nodemailer from 'nodemailer';

export async function POST(request: Request) {
  // Отладка: выводим переменные окружения (без пароля)
  console.log('[Investment Mailer] SMTP_HOST:', process.env.SMTP_HOST);
  console.log('[Investment Mailer] SMTP_PORT:', process.env.SMTP_PORT);
  console.log('[Investment Mailer] SMTP_USER:', process.env.SMTP_USER);
  console.log('[Investment Mailer] INVESTMENT_EMAIL:', process.env.INVESTMENT_EMAIL);

  if (!process.env.SMTP_HOST || !process.env.SMTP_PORT || !process.env.SMTP_USER || !process.env.SMTP_PASSWORD || !process.env.INVESTMENT_EMAIL) {
    console.error('[Investment Mailer] Не хватает переменных окружения для SMTP');
    return NextResponse.json(
      { error: 'Email configuration is missing' },
      { status: 500 }
    );
  }

  try {
    const { firstName, lastName, email, phone, subject, format } = await request.json();
    console.log('[Investment Mailer] Данные формы:', { firstName, lastName, email, phone, subject, format });

    // Создаем транспорт для отправки почты
    const transporter = nodemailer.createTransport({
      host: process.env.SMTP_HOST,
      port: Number(process.env.SMTP_PORT),
      secure: true,
      auth: {
        user: process.env.SMTP_USER,
        pass: process.env.SMTP_PASSWORD,
      },
    });

    // Формируем текст письма
    const mailOptions = {
      from: process.env.SMTP_USER,
      to: process.env.INVESTMENT_EMAIL,
      subject: `Investment Access Request: ${subject}`,
      html: `
        <h2>New Investment Access Request</h2>
        <p><strong>Name:</strong> ${firstName} ${lastName}</p>
        <p><strong>Email:</strong> ${email}</p>
        <p><strong>Phone:</strong> ${phone}</p>
        <p><strong>Subject:</strong> ${subject}</p>
        <p><strong>Interested Format:</strong> ${format}</p>
        <br>
        <p><em>This request was submitted from the investment form on the website.</em></p>
      `,
    };

    // Отправляем письмо
    const result = await transporter.sendMail(mailOptions);
    console.log('[Investment Mailer] Результат отправки:', result);

    return NextResponse.json({ success: true });
  } catch (error) {
    console.error('[Investment Mailer] Ошибка при отправке email:', error);
    return NextResponse.json(
      { error: 'Failed to send investment request' },
      { status: 500 }
    );
  }
} 