import { NextResponse } from 'next/server';
import nodemailer from 'nodemailer';

export async function POST(request: Request) {
  // Отладка: выводим переменные окружения (без пароля)
  console.log('[Mailer] SMTP_HOST:', process.env.SMTP_HOST);
  console.log('[Mailer] SMTP_PORT:', process.env.SMTP_PORT);
  console.log('[Mailer] SMTP_USER:', process.env.SMTP_USER);
  console.log('[Mailer] CONTACT_EMAIL:', process.env.CONTACT_EMAIL);

  if (!process.env.SMTP_HOST || !process.env.SMTP_PORT || !process.env.SMTP_USER || !process.env.SMTP_PASSWORD || !process.env.CONTACT_EMAIL) {
    console.error('[Mailer] Не хватает переменных окружения для SMTP');
    return NextResponse.json(
      { error: 'Email configuration is missing' },
      { status: 500 }
    );
  }

  try {
    const { firstName, lastName, email, phone, subject, message } = await request.json();
    console.log('[Mailer] Данные формы:', { firstName, lastName, email, phone, subject, message });

    // Создаем транспорт для отправки почты
    const transporter = nodemailer.createTransport({
      host: process.env.SMTP_HOST,
      port: Number(process.env.SMTP_PORT),
      secure: true,
      auth: {
        user: process.env.SMTP_USER,
        pass: process.env.SMTP_PASSWORD,
      },
    });

    // Формируем текст письма
    const mailOptions = {
      from: process.env.SMTP_USER,
      to: process.env.CONTACT_EMAIL,
      subject: `New Contact Form Submission: ${subject}`,
      html: `
        <h2>New Contact Form Submission</h2>
        <p><strong>Name:</strong> ${firstName} ${lastName}</p>
        <p><strong>Email:</strong> ${email}</p>
        <p><strong>Phone:</strong> ${phone}</p>
        <p><strong>Subject:</strong> ${subject}</p>
        <p><strong>Message:</strong></p>
        <p>${message}</p>
      `,
    };

    // Отправляем письмо
    const result = await transporter.sendMail(mailOptions);
    console.log('[Mailer] Результат отправки (объект):', result);
    try {
      console.log('[Mailer] Результат отправки (JSON):', JSON.stringify(result, null, 2));
    } catch (e) {
      console.log('[Mailer] Не удалось сериализовать результат:', e);
    }

    return NextResponse.json({ success: true });
  } catch (error) {
    console.error('[Mailer] Ошибка при отправке email:', error);
    return NextResponse.json(
      { error: 'Failed to send message' },
      { status: 500 }
    );
  }
} 