@extends('layouts.site')

@section('title') {{$postData->title}} @endsection

@section('content')
    <div class="content page__content">
        <section class="post content__post">
            <div class="post__info">
                <p class="post__date">{!! Date::parse($postData->created_at)->format('j F Y') !!}</p>
                <p class="post__counter"><span class="post__counter-icon"></span>{!!$postData->views!!}</p>
            </div>
            <h3 class="post__heading">{!!$postData->title!!}</h3>
            <div class="post__img-wrapper">
                @if (!empty($prevSlug))
                    <a href="{{route('media.view-post',['slug' => $prevSlug])}}" class="navigation post__navigation post__navigation_left">
                        <p class="navigation__text navigation__text_left">{{ Lang::get('castle.previous') }}</p>
                    </a>
                @endif
                <img src="/storage/{!! $postData->image !!}" alt="" class="post__img">
                @if (!empty($nextSlug))
                    <a href="{{route('media.view-post',['slug' => $nextSlug])}}" class="navigation post__navigation post__navigation_right">
                        <p class="navigation__text navigation__text_right">{{ Lang::get('castle.next') }}</p>
                    </a>
                @endif
            </div>

            <div class="post__text">{!!$postData->body!!}</div>

        </section>
    </div>
@endsection
@section('js')
    <script src="{{ mix('js/nav-menu.js') }}"></script>

@endsection