@extends('layouts.site')

@section('title') {{$vacancy->title}} @endsection

@section('content')
    <div class="content page__content">
        <section class="career content__block">
            <h3 class="heading career__title">@lang('castle.career')</h3>
            <div class="career__img-block">
                <div class="career__img"></div>
                <div class="navigation career__navigation">
                    <p class="navigation__text navigation__text_right career__navigation-text"
                       data-current-country="{{$currentCountry}}">@lang('castle.career.countries')</p>
                </div>
            </div>
            <div class="career__country-list">
                @foreach($countries as $countryItem)
                    @includeIf('includes.country-list')
                @endforeach
            </div>
            <h3 class="career__country">{{ Lang::get('castle.career.'.$currentCountry) }}</h3>
            <div class="divider career__divider"></div>
            <div class="career__column">
                <ul class="career__vacancy-list">
                    @foreach($vacancyList as $vacancyItem)
                        @includeIf('includes.vacancy-list')
                    @endforeach
                </ul>


                <div class="vacancy career__vacancy">
                    {!! $vacancy->description !!}
                </div>
                <div class="career__button-wrapper">
                    <div class="button button_dark-grey career__button">@lang('castle.career.quick_apply')</div>
                </div>
                <div class="career__logo-wrapper">
                    <div class="career__logo">&nbsp;</div>
                </div>
                <div class="career__text-block">
                    <div class="career__line">&nbsp;</div>
                    <p class="career__text">@lang('castle.career.common_text_1')</p>
                    <p class="career__text">@lang('castle.career.common_text_2')</p>
                </div>
            </div>
        </section>
    </div>
@endsection
@section('js')
    <script src="{{ mix('js/nav-menu.js') }}"></script>
    <script src="{{ mix('js/career.js') }}"></script>
    <script src="{{ mix('js/intlTelInput.js') }}"></script>
    <script src="{{ mix('js/utils.js') }}"></script>
@endsection