@extends('layouts.site')

@section('title') {{$pageData->title}} @endsection

@section('content')
    <div class="content page__content">
        {!! $pageData->body !!}
        <section class="media-coverage content__block" id="media-coverage">
            <h3 class="heading media-coverage__heading">@lang('castle.our-media-coverage')</h3>
            <hr class="divider media-coverage__divider">
            <div class="news-blocks">
                @foreach($mediaCoverages as $post)
                    @includeIf('includes.preview-post')
                @endforeach
            </div>
            <div class="navigation media-coverage__navigation">
                <a href="{{ route('media.media-coverage') }}"
                   class="navigation__text navigation__text_right navigation__text_grey">{{ Lang::get('castle.all_news') }}</a>
            </div>
        </section>

        {!! $pageData->body_bottom !!}
        <section class="media-coverage content__block" id="media-coverage">
            <h3 class="heading media-coverage__heading">@lang('castle.market-update')</h3>
            <hr class="divider media-coverage__divider">
            <div class="news-blocks">
                @foreach($marketUpdates as $post)
                    @includeIf('includes.preview-post')
                @endforeach
            </div>
            <div class="navigation media-coverage__navigation">
                <a href="{{ route('media.market-update') }}"
                   class="navigation__text navigation__text_right navigation__text_grey">{{ Lang::get('castle.all_news') }}</a>
            </div>
        </section>

    </div>
@endsection
@section('js')
    <script src="{{ mix('js/nav-menu.js') }}"></script>
    <script src="{{ mix('js/slider.js') }}"></script>
    <script src="{{ mix('js/intlTelInput.js') }}"></script>
    <script src="{{ mix('js/utils.js') }}"></script>
    <script src="{{ mix('js/become-client.js') }}"></script>
@endsection