@extends('layouts.site')

@section('title') {{ Lang::get('marketplace.all_news') }}@endsection

@section('content')
    <div class="content page__content">
        <section class="post-list content__post-list">
            <h3 class="heading post-list__heading">{{ Lang::get('marketplace.all_news') }}</h3>
            <div class="row">
                @foreach($posts as $post)
                    <article class="col-sm-6 col-md-4 news-block news-block_centered">
                        <img src="/storage/{!! $post->image !!}" alt="{{ $post->title }}"
                             class="img-responsive center-block news-block__img news-block__img_centered">
                        <div class="date news-block__date">{!! date('d.m.Y',strtotime($post->created_at))!!}</div>
                        <p class="news-block__counter"><span class="counter-icon"></span>{!!$post->views!!}</p>
                        <h4 class="date news-block__heading">{{ $post->title }}</h4>
                        <a href="{{route('media.view-post',['slug' => $post->slug])}}"
                           class="read-more news-block__read-more">{{ Lang::get('marketplace.read_more') }}...</a>
                    </article>
                @endforeach
            </div>

        </section>
    </div>
@endsection
@section('js')
    <script src="{{ mix('js/nav-menu.js') }}"></script>
@endsection