import 'drawsvg/public/jquery.drawsvg.js';

jQuery(document).ready(function () { // wait for document ready
    var $showedAwards = false;
    var $showedLines = false;
    var $showedadvantagesLines = false;
    var $introVideoInViewport = false;
    var introVideo = document.getElementsByClassName("intro__video")[0];

    $.fn.isInViewport = function (topShift, bottomShift) {
        if (topShift === undefined) {
            topShift = 0;
        }
        if (bottomShift === undefined) {
            bottomShift = 0;
        }
        var elementTop = $(this).offset().top;
        var elementBottom = elementTop + $(this).outerHeight();
        var viewportTop = $(window).scrollTop();
        var viewportBottom = viewportTop + $(window).height();
        //   console.log('el_bottom: ' + elementBottom + ' el_top: ' + elementTop + ' vt: ' + viewportTop + ' vb: ' + viewportBottom);
        return (elementBottom + bottomShift) > viewportTop && (elementTop + topShift) < viewportBottom;
    };
    $(window).on('load resize scroll', function () {
        if ($('.intro').isInViewport()) {
            // console.log('in');
            if ($introVideoInViewport !== true) {
                $introVideoInViewport = true;

                //   console.log(introVideo);
                introVideo.play();
            }

        }
        else {
            //  console.log('out');
            $introVideoInViewport = false;
            introVideo.pause();
            introVideo.currentTime = 0;
        }

        if ($('.awards__images').isInViewport()) {
            if (window.innerWidth >= 1024 && ($showedAwards !== true)) {
                $showedAwards = true;
                $(".awards__phone").css({'left': '1vw', 'transition': 'left 1.5s'});
                $(".awards__heading").css({'left': '0', 'transition': 'left 1.5s'});
                $(".awards__notebook").css({'left': '8vw', 'transition': 'left 1s', 'transition-delay': '1s'});
                $(".awards__sing").css({'opacity': '1', 'transition': 'opacity 1s', 'transition-delay': '2s'});
            }
        }
        else {
            if (window.innerWidth >= 1024) {
                $showedAwards = false;
                $(".awards__phone").css({'left': '100%', 'transition': 'left 0.1s'});
                $(".awards__heading").css({'left': '-40%', 'transition': 'left 0.1s'});
                $(".awards__notebook").css({'left': '100%', 'transition': 'left 0.1s'});
                $(".awards__sing").css({'opacity': '0', 'transition': 'opacity 0.1s'});
            }
        }


        if ($('.solutions__lines-wrapper').isInViewport()) {
            //console.log($('.solutions__lines').css("display"));
            if (window.innerWidth >= 1200) {
                $('.solutions__lines').css("display", "block");
                if ($showedLines !== true) {
                    var colorCounter = 0;
                    var mySVG = $('.solutions__lines').drawsvg({
                        duration: 300,
                        stagger: 300,
                        callback: function () {
                            switch (colorCounter) {
                                case 0:  // if (x === 'value1')
                                    $('.solutions__list').removeClass("solutions__list_showed_1");
                                    $('.solutions__list').removeClass("solutions__list_showed_2");
                                    $('.solutions__lines > .line').css({stroke: "#C0F5B8"});
                                    $('.solutions__lines > .point').css({stroke: "#C0F5B8"});
                                    colorCounter++;
                                    $('.solutions__list').addClass("solutions__list_showed_0");
                                    mySVG.drawsvg('animate');
                                    break;
                                case 1:  // if (x === 'value2')
                                    $('.solutions__list').removeClass("solutions__list_showed_0");
                                    $('.solutions__list').removeClass("solutions__list_showed_2");
                                    $('.solutions__lines > .line').css({stroke: "#1E843A"});
                                    $('.solutions__lines > .point').css({stroke: "#1E843A"});
                                    colorCounter++;
                                    $('.solutions__list').addClass("solutions__list_showed_1");
                                    mySVG.drawsvg('animate');
                                    break;
                                case 2:  // if (x === 'value2')
                                    $('.solutions__list').removeClass("solutions__list_showed_0");
                                    $('.solutions__list').removeClass("solutions__list_showed_1");
                                    $('.solutions__lines > .line').css({stroke: "#e7e7e7"});
                                    $('.solutions__lines > .point').css({stroke: "#e7e7e7"});
                                    colorCounter = 0;
                                    $('.solutions__list').addClass("solutions__list_showed_2");
                                    mySVG.drawsvg('animate');
                                    break;
                            }
                        }
                    });
                    //   console.log('go!');
                    mySVG.drawsvg('animate');
                    $showedLines = true;
                }
                $('.solutions__item').css("opacity", "1");
            }
            else if ($('.solutions__lines').css("display") === "block") {
                $('.solutions__lines').css("display", "none");
            }
        }
        var animated = false;
        if ($('.advantages').isInViewport()) {
            //console.log($('.advantages__lines').css("display"));
            if (!$showedadvantagesLines) {
                $('.advantages__line').css("display", "block");
                if ($showedLines !== true) {
                    $showedLines = true;
                    animated = true;
                    var mySVG2 = $('.advantages__line').drawsvg({
                        duration: 1200,
                        stagger: 1000,
                        callback: function () {
                            $showedadvantagesLines = false;
                            //  console.log('anim finish:' + $showedLines);
                            animated = false;
                        }

                    });
                    //  console.log('go!');
                    mySVG2.drawsvg('animate');
                    //   $showedadvantagesLines = true;
                }
                $('.solutions__item').css("opacity", "1");
            }
            else if ($('.solutions__lines').css("display") === "block") {
                // $('.solutions__lines').css("display", "none");
            }
        }
        else if (!animated) {
            $showedadvantagesLines = false;

        }
        if ($('.become-user__phone').isInViewport(50)) {
            $('.become-user__phone').addClass('become-user__phone_on');
        }
        else if ($('.become-user__phone').hasClass('become-user__phone_on')) {
            $('.become-user__phone').removeClass("become-user__phone_on");
        }
    });
});