const mix = require('laravel-mix');

/*
 |--------------------------------------------------------------------------
 | Mix Asset Management
 |--------------------------------------------------------------------------
 |
 | Mix provides a clean, fluent API for defining some Webpack build steps
 | for your Laravel application. By default, we are compiling the Sass
 | file for the application as well as bundling up all the JS files.
 |
 */

mix.js('resources/js/app.js', 'public/js')
   .js('resources/js/animation.js', 'public/js')
   .js('resources/js/slider.js', 'public/js')
   .js('resources/js/become-client.js', 'public/js')
   .js('resources/js/feedback.js', 'public/js')
   .js('resources/js/career.js', 'public/js')
   .js('resources/js/google-maps.js', 'public/js')
   .js('resources/js/nav-menu.js', 'public/js')
   .copy('node_modules/intl-tel-input/build/js/intlTelInput.js', 'public/js')
   .copy('node_modules/intl-tel-input/build/js/utils.js', 'public/js')
   .copy('node_modules/intl-tel-input/build/css/intlTelInput.css', 'public/css')
   .copy('resources/images', 'public/images')
   .copy('resources/js/tiny-editor.js', 'public/js')
   .sass('resources/sass/app.scss', 'public/css');



mix.autoload({
    'jquery': ['$', 'window.jQuery','jQuery','window.$','jquery','window.jquery'],
});


if (mix.config.production) {
    mix.version();
    mix.disableNotifications();
} else {
    mix.browserSync('cfo.lc');
}
