<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use TCG\Voyager\Traits\HasRelationships;
use TCG\Voyager\Traits\Translatable;
use Carbon\Carbon;

class Post extends \TCG\Voyager\Models\Post
{
    use Translatable;

    protected $translatable = ['title', 'body', 'excerpt'];

    public function scopeMediaCoverage($query) {
        return $query->whereCategoryId('1');
    }

    public function scopeMarketUpdate($query) {
        return $query->whereCategoryId('2');
    }

    public function nextPost() {
        // get next post

        return Post::where('category_id', $this->category_id)->
        where('created_at', '>', $this->created_at)->
        orderBy('created_at', 'ASC')->first();
    }

    public function previousPost() {
        // get previous post

        return Post::where('category_id', $this->category_id)->
        where('created_at', '<', $this->created_at)->
        orderBy('created_at', 'DESC')->first();


    }

}
