<?php

// use Config;
// use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;


function getUrlsBylangs($chosenLang)
{
    $currentUrl = Request::fullUrl();
    $queryString = parse_url($currentUrl,  PHP_URL_QUERY);
    if($queryString===NULL){
        $queryString ='';
    }
    else{
        $queryString ='?'.$queryString;
    }

    $segments = Request::segments();
    $lang = Request::segment(1);
    $baseURL = url('/');
    $defaultLang = config('app.fallback_locale');

    if (!in_array($lang, config('app.locales'))){
        $lang = $defaultLang;                //  set $lang for url without language code
    }

    if ($lang == $defaultLang){
        if ($chosenLang == $defaultLang){
            return $currentUrl;
        }
        else {
            $segments = array_prepend($segments,  $chosenLang);
            return $baseURL.'/'.implode('/', $segments).$queryString;
        }
    }
    else {
        if ($chosenLang == $defaultLang){
            array_shift($segments);                           //remove /$defaultLang/ from URI
            return $baseURL.'/'.implode('/', $segments).$queryString;
        }
        else {
            $segments[0] = $chosenLang;
            return $baseURL.'/'.implode('/', $segments).$queryString;
        }
    }
}