<?php

namespace App\Http\Controllers;

use App\Career;
use App\Country;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Response;
use Validator;
use Mail;
use File;

class VacanciesController extends Controller
{
    public function getCountryID ($countryName){
        $countryData = Country::where('country_name', $countryName)->first();
        return $countryData->id;
    }
    public function getVacancyList($countryID){
        $vacancyList = Career::where('country_id', $countryID)->orderBy('title', 'asc')->get();
        $t = 0;
        $translatedVacancyList = [];
        foreach ($vacancyList as $vacancy) {
            $translatedVacancyList[$t] = $vacancy->translate('locale', app()->getLocale());
            $t++;
        }
        return $translatedVacancyList;
    }
    public function index (Request $request ) {
        $firstCountry = Country::first();
        $vacancyList = $this->getVacancyList($firstCountry->id);
        $firstVacancy = $vacancyList[0]->translate('locale',  app()->getLocale());
        $countries = Country::all(); // получаем полный список стран
        return view('pages.vacancy')->with('vacancy', $firstVacancy)->with('currentCountry', $firstCountry->country_name)->with('vacancyList', $vacancyList)->with('countries', $countries);
    }

    public function chooseCountry(Request $request, $country) {
        $countries = Country::all(); // получаем полный список стран
        return view('includes.choose-country')->with('currentCountry', $country)->with('countries', $countries)->render();
    }

    public function viewCountry(Request $request, $country ) {
        $countryID = $this->getCountryID($country);
        $vacancyList = $this->getVacancyList($countryID);
        $firstVacancy = $vacancyList[0]->translate('locale',  app()->getLocale());
        $countries = Country::all(); // получаем полный список стран
        return view('pages.vacancy')->with('vacancy', $firstVacancy)->with('currentCountry', $country)->with('vacancyList', $vacancyList)->with('countries', $countries);
    }

    public function viewVacancy(Request $request, $country, $vacancy ) {
        $slug = 'career/'.$country.'/'.$vacancy;
        $vacancyData = Career::where('slug', $slug)->first();
        $vacancyData = $vacancyData->translate('locale',  app()->getLocale() );
        $countries = Country::all(); // получаем полный список стран

        $vacancyList = $this->getVacancyList($vacancyData->country_id);

      //  $vacancyData = $vacancyData->translate('locale', app()->getLocale());
       // dd($vacancyList);
        return view('pages.vacancy')->with('vacancy', $vacancyData)->with('currentCountry', $country)->with('vacancyList', $vacancyList)->with('countries', $countries);
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public
    function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public
    function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public
    function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public
    function destroy($id)
    {
        //
    }
}
