<?php

namespace App\Http\Controllers;

use App\Page;
use App\Post;
use Jenssegers\Date\Date;

use Illuminate\Http\Request;

class PagesController extends Controller
{
    public function getPageData ($slug){
        $pageData = Page::where('slug', $slug)->first();
        $pageData = $pageData->translate('locale',  app()->getLocale() );
        return $pageData;
    }
    //
    public function home() {
       // $pageData = Page::where('slug', 'home')->first();

        $mediaCoveragePosts = Post::mediaCoverage()->orderBy('created_at','DESC')->take(3)->get();
        $marketUpdatePosts = Post::marketUpdate()->orderBy('created_at','DESC')->take(3)->get();
        $t = 0;
        $translatedMCP = []; // MCP - Media Coverage Posts
        foreach ($mediaCoveragePosts as $post) {
            $translatedMCP[$t] = $post->translate('locale', app()->getLocale());
            $t++;
        }
        $t = 0;
        $translatedMUP = []; // MUP - Market Update Posts
        foreach ($marketUpdatePosts as $post) {
            $translatedMUP[$t] = $post->translate('locale', app()->getLocale());
            $t++;
        }
        Date::setLocale(app()->getLocale()); //for correct layout of posts date
        return view('home')->with('pageData', $this->getPageData('home'))->with('mediaCoverages', $translatedMCP)->with('marketUpdates', $translatedMUP);
    }

    public function aboutUs() {
        return view('pages.about-us')->with('pageData', $this->getPageData('about-us'));
    }
    public function career() {
        return view('pages.vacancy');
    }

    public function ourPartners() {
        return redirect(route('home') . '#our-partners');
    }

    public function mediaCoverage() {
        return redirect(route('home') . '#media-coverage');
    }

    public function contactUs() {
        return view('pages.contact-us')->with('pageData', $this->getPageData('contact-us'));
    }


    public function privateWealth() {
        return view('pages.private-wealth.private-wealth')->with('pageData', $this->getPageData('/private-wealth/private-wealth'));
    }
    public function trustAndEstatePlanning() {
        return view('pages.private-wealth.trust-and-estate-planning')->with('pageData', $this->getPageData('/private-wealth/trust-and-estate-planning'));
    }
    public function assetsOwnership() {
        return view('pages.private-wealth.assets-ownership')->with('pageData', $this->getPageData('/private-wealth/assets-ownership'));
    }
    public function realEstateInvestment() {
        return view('pages.private-wealth.real-estate-investment-and-management')->with('pageData', $this->getPageData('/private-wealth/real-estate-investment-and-management'));
    }
    public function foreignResidence() {
        return view('pages.private-wealth.foreign-residence-and-citizenship')->with('pageData', $this->getPageData('/private-wealth/foreign-residence-and-citizenship'));
    }


    public function legalSupport() {
        return view('pages.legal-support.legal-support')->with('pageData', $this->getPageData('/legal-support/legal-support'));
    }
    public function regulatoryAndCompliance() {
        return view('pages.legal-support.regulatory-and-compliance')->with('pageData', $this->getPageData('/legal-support/regulatory-and-compliance'));
    }
    public function contractsAndCommercial() {
        return view('pages.legal-support.contracts-and-commercial')->with('pageData', $this->getPageData('/legal-support/contracts-and-commercial'));
    }
    public function governanceAndRisk() {
        return view('pages.legal-support.governance-and-risk')->with('pageData', $this->getPageData('/legal-support/governance-and-risk'));
    }
    public function taxPlanning() {
        return view('pages.legal-support.tax-planning')->with('pageData', $this->getPageData('/legal-support/tax-planning'));
    }

    public function successionPlanning() {
        return view('pages.corporate-services.succession-planning')->with('pageData', $this->getPageData('/corporate-services/succession-planning'));
    }
    public function incorporationAndAdministrationCompanies() {
        return view('pages.corporate-services.incorporation-and-administration-of-companies')->with('pageData', $this->getPageData('/corporate-services/incorporation-and-administration-of-companies'));
    }
    public function establishmentManagementAndAdministrationTrusts() {
        return view('pages.corporate-services.establishment-management-and-administration-of-trusts')->with('pageData', $this->getPageData('/corporate-services/establishment-management-and-administration-of-trusts'));
    }
    public function accountingAndTaxPackagesForCompanies() {
        return view('pages.corporate-services.accounting-and-tax-packages-for-companies')->with('pageData', $this->getPageData('/corporate-services/accounting-and-tax-packages-for-companies'));
    }

    public function termsOfUse() {
        return view('terms-of-use')->with('pageData', $this->getPageData('terms-of-use'));
    }
    public function privacyPolicy() {
        return view('privacy-policy')->with('pageData', $this->getPageData('privacy-policy'));
    }
    public function cookiesPolicy() {
        return view('cookies-policy')->with('pageData', $this->getPageData('cookies-policy'));
    }
    public function tou() {
        return view('tou');
    }


    public function chooseTypeForm() {
        return view('includes.choose-client-type')->render();
    }
}