<?php

namespace App\Http\Controllers;

use App\Post;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Jenssegers\Date\Date;

class MediaController extends Controller
{
    public function index() {
        $posts = Post::orderBy('created_at', 'DESC')->get();
        $t = 0;
        $translatedPosts = [];
        foreach ($posts as $post) {
            $translatedPosts[$t] = $post->translate('locale', app()->getLocale());
            $t++;
        }
        return view('allnews')->with('posts', $translatedPosts);
    }

    public function mediaCoverage() {
        $posts = Post::mediaCoverage()->orderBy('created_at', 'DESC')->get();
        $t = 0;
        $translatedPosts = [];
        foreach ($posts as $post) {
            $translatedPosts[$t] = $post->translate('locale', app()->getLocale());
            $t++;
        }
        return view('pages.our-media-coverage')->with('posts', $translatedPosts);
    }

    public function marketUpdate() {
        $posts = Post::marketUpdate()->orderBy('created_at', 'DESC')->get();
        $t = 0;
        $translatedPosts = [];
        foreach ($posts as $post) {
            $translatedPosts[$t] = $post->translate('locale', app()->getLocale());
            $t++;
        }
        return view('pages.market-update')->with('posts', $translatedPosts);
    }

    public function viewPost(Request $request, $slug) {
        $postData = Post::where('slug', $slug)->first();
        $prevPost = $postData->previousPost();
        $nextPost = $postData->nextPost();
     //   $ff = $postData->created_at->toFormattedDateString();

     //  $ff = $postData->created_at->isoFormat('D MMMM G');
      // dd($ff);
        if ($prevPost){
            $prevSlug = $prevPost->slug;
        }
        else{
            $prevSlug = null;
        }
        if ($nextPost){
            $nextSlug = $nextPost->slug;
        }
        else{
            $nextSlug = null;
        }
        $postID = $postData->id;
        $sessionFlagName = 'post' . $postID . '_viewed';
        if (!$request->session()->has($sessionFlagName)) {
            $request->session()->put($sessionFlagName, 'true');
            $postData->views = $postData->views + 1;
            $postData->save();
        }
        Date::setLocale(app()->getLocale());
        $postData = $postData->translate('locale', app()->getLocale());
        return view('post')->with('postData', $postData)->with('prevSlug', $prevSlug)->with('nextSlug', $nextSlug);
    }
}
