<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Response;
use Validator;
use Mail;
use File;

class IndividualClientController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index() {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {
        return view('includes.become-client-indiv')->render();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request) {
        /** @var $rules - form validation */
        $individualType = $request->get('individual_client_type');
        If ($individualType == 'Private investor') {
            $findMoreFlag = $request->input('find_out_more');
            //    dd($findMoreFlag);
            if ($findMoreFlag) {
                $rules = [
                    'name' => "required",
                    'phone' => 'required',
                    'email' => 'required|email',
                    'how_know' => 'required',
                    'interested_products' => 'required|not_in:none',
                ];
            } else {
                $rules = [
                    'name' => "required",
                    'passport_id' => 'required',
                    'passport_id_file' => 'required|mimes:jpeg,bmp,png,gif|max:4096',
                    'phone' => 'required',
                    'email' => 'required|email',
                    'how_know' => 'required',
                    'interested_products' => 'required|not_in:none',
                ];
            }
        } elseif ($individualType == 'Financial advisor') {
            $rules = [
                'name' => "required",
                'passport_id' => 'required',
                'passport_id_file' => 'required|mimes:jpeg,bmp,png,gif|max:4096',
                'phone' => 'required',
                'email' => 'required|email',
                'how_know' => 'required',
                'interested_products' => 'required|not_in:none',
                'cv_file' => 'required|mimes:doc,docx,txt,pdf|max:4096',
            ];
        } else {
            $rules = [
                'individual_client_type' => "required|in:(['Financial advisor', 'Private investor'])",
            ];
        }

        $validator = Validator::make($request->all(), $rules);

        if ($validator->fails()) {
            return Response::json($validator->errors(), 422);
        }

        /** Send e-mail on info@castle-familyoffice.sg */
        $success = false;
        $find_out_more = $request->input('find_out_more');
        $name_field = $request->get('name');
        $passport_id_field = $request->get('passport_id');
        $phone_field = $request->get('phone');
        $email_field = $request->get('email');
        $interested_products_field = $request->get('interested_products');
        $passport_file = $request->file('passport_id_file');
        $cv_file = $request->file('cv_file');

        $mail_admin = 'noreply@evm-marketplace.com';
        $data = [
            'clientType' => $individualType,
            'name' => $name_field,
            'findMoreFlag' => $find_out_more,
            'passportID' => $passport_id_field,
            'phone' => $phone_field,
            'email' => $email_field,
            'interestedProduct' => $interested_products_field,
            'subject' => 'Request from Become a user form (Individual) at evm-marketplace.com',
            'from' => $mail_admin,
            'passport_file' => $passport_file,
            'cv_file' => $cv_file,
        ];

        Mail::send('requests.indiv-client', $data, function ($message) use ($data) {
            $message->from($data['from'], 'EVM Marketplace');
            //  $message->from($data['email'], $data['name'], $data['country'], $data['phone'] );
            $message->to('info@evm-marketplace.com');
            $message->subject($data['subject']);
            if ($data['clientType'] == 'Private investor' && !$data['findMoreFlag']) {
                $message->attachData(File::get($data['passport_file']), str_slug($data['name'] . '_passport') . '.' . $data['passport_file']->getClientOriginalExtension(), ['mime' => $data['passport_file']->getMimeType()]);
            } elseif ($data['clientType'] == 'Financial advisor') {
                $message->attachData(File::get($data['passport_file']), str_slug($data['name'] . '_passport') . '.' . $data['passport_file']->getClientOriginalExtension(), ['mime' => $data['passport_file']->getMimeType()]);
                $message->attachData(File::get($data['cv_file']), str_slug($data['name'] . '_cv') . '.' . $data['cv_file']->getClientOriginalExtension(), ['mime' => $data['cv_file']->getMimeType()]);
            }
        });

        $success = true;

        if ($success) {

            Session::flash('success', 'Success');

            return Response::json($success, 200);
        } else {
            Response::json(['There is an error while sending an e-mail'], 422);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public
    function show($id) {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public
    function edit($id) {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public
    function update(Request $request, $id) {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public
    function destroy($id) {
        //
    }
}
