<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Response;
use Validator;
use Mail;
use File;

class CorporateClientController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index() {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {
        return view('includes.become-client-corp')->render();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request) {
        /** @var $rules - form validation */

            $rules = [
                'full_name' => "required",
                'email' => 'required|email',
            ];


        $validator = Validator::make($request->all(), $rules);

        if ($validator->fails()) {
            return Response::json($validator->errors(), 422);
        }

        /** Send e-mail on info@castle-familyoffice.sg */
        $success = false;
        $slide_text_field = $request->get('slide_text');
        $full_name_field = $request->get('full_name');
        $phone_field = $request->get('phone');
        $email_field = $request->get('email');

        $mail_admin = 'info@castle-familyoffice.sg';
        $data = [
            'slideText' => $slide_text_field,
            'fullName' => $full_name_field,
            'phone' => $phone_field,
            'email' => $email_field,
            'subject' => 'Request from Become a user form castle-familyoffice.sg',
            'from' => $mail_admin,
        ];

        Mail::send('requests.corp-client', $data, function ($message) use ($data) {
            $message->from($data['from'], 'Castle Family Office');
            $message->to('info@castle-familyoffice.sg');
            $message->subject($data['subject']);
            $fileCounter = 0;
        });

        $success = true;

        if ($success) {

            Session::flash('success', 'Success');

            return Response::json($success, 200);
        } else {
            Response::json(['There is an error while sending an e-mail'], 422);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id) {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id) {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id) {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id) {
        //
    }
}
